% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core3D.R
\name{turnLiftStepHist}
\alias{turnLiftStepHist}
\title{Three dimensional histogram}
\usage{
turnLiftStepHist(
  turn,
  lift,
  step,
  printDims = TRUE,
  rm.zeros = TRUE,
  maxBin = 25
)
}
\arguments{
\item{turn}{numeric vector of turn angles}

\item{lift}{numeric vector of lift angles}

\item{step}{numeric vector of step lengths}

\item{printDims}{logical: should dimensions of tld-Cube be messaged?}

\item{rm.zeros}{logical: should combinations with zero probability be removed?}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube.}
}
\value{
A three dimensional histogram as data.frame
}
\description{
Derives a three dimensional distribution of a turn angle,
lift angle and step length, using the Freedman–Diaconis rule for
estimating the number of bins.
}
\examples{
niclas <- track.properties.3d(niclas)[2:nrow(niclas), ]
turnLiftStepHist(niclas$t, niclas$l, niclas$d)
}
