% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line.R
\name{line.svg}
\alias{line.svg}
\title{Generate line SVG element}
\usage{
line.svg(x1 = NULL, y1 = NULL, x2 = NULL, y2 = NULL, stroke,
  stroke.width, stroke.opacity, stroke.dasharray, style.sheet = NULL)
}
\arguments{
\item{x1}{a number, x1 coordinate information}

\item{y1}{a number, y1 corrdinate information}

\item{x2}{a number, x2 corrdiante information}

\item{y2}{a number, y2 corrdinate information}

\item{stroke}{a characher, color of the line, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the line, default: 1}

\item{stroke.opacity}{a number, stroke opacity of the line, default:1. If the stroke opacity is 0, the line is invisible}

\item{stroke.dasharray}{a vector, plot the dotted line, eg. c(9, 5)}

\item{style.sheet}{a vector or a chatacter, other style of the line, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function will generate a line form SVG element.
The <line> element is an SVG basic shape used to create a line connecting two points.
}
\examples{
line.svg(x1 = 1, y1 = 2, x2 = 10, y2 = 20)
line.svg(x1 = 1, y1 = 2, x2 = 10, y2 = 20, stroke = "#00FF00")
line.svg(x1 = 1, y1 = 2, x2 = 10, y2 = 20, stroke.dasharray = c(9, 5))


}
