% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ploygon.R
\name{polygon.svg}
\alias{polygon.svg}
\title{Generate polygon SVG element}
\usage{
polygon.svg(points = NULL, fill, fill.opacity, stroke, stroke.width,
  stroke.opacity, fill.rule, style.sheet = NULL)
}
\arguments{
\item{points}{a matrix, a series of coordinates}

\item{fill}{a character, color of the polygon, eg. "#000000"(default), "red"}

\item{fill.opacity}{a number, stroke opacity of the polygon, default:1. If the fill opacity is 0, the polygon's internal color is invisible}

\item{stroke}{a characher, color of the polygon line, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the polygon line, default: 1}

\item{stroke.opacity}{a number, stroke opacity of the polygon line, default:1. If the stroke opacity is 0, the polygon line is invisible}

\item{fill.rule}{a character, fill rule of polygon, eg. "nonzero", "evenodd"}

\item{style.sheet}{a vector or a chatacter, other style of the polygon, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function can generate a polygon form SVG element
The <polygon> element defines a closed shape consisting of a set of
connected straight line segments. The last point is connected to the
first point. For open shapes see the <polyline> element.
}
\examples{
points <- matrix(c(1,2,3, 11,12,13), nrow = 3, ncol = 2)
polygon.svg(points = points)
polygon.svg(points = points, fill = "red", stroke = "yellow", fill.rule = "evenodd")


}
