% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTest.R
\name{TTest}
\alias{TTest}
\title{Perform t-test on easynem meta-table by treatment (single factor)}
\usage{
TTest(data, .group, y, ...)
}
\arguments{
\item{data}{An \code{\link{easynem-class}} data.}

\item{.group}{Grouping variables (supports only two groups).}

\item{y}{Dependent variable (numeric data).}

\item{...}{Other parameters for \code{\link[stats]{t.test}}.}
}
\value{
An \code{\link{compare-class}} object.
}
\description{
The \code{TTest()} is used to perform \code{t-test} for grouped data and create
\code{\link{compare-class}}. This function is only applicable to single factor
analysis, see \code{\link{TTest2}} for a two factor version of the function.
}
\details{
Note: The \code{t-test} is only applicable to comparisons between two groups
of data. To facilitate code interpretation, It is recommended to use this
function in conjunction with the \code{\link{calc_compare}} function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_compare <- nem |> calc_compare(.group = con_crop, y = pH, method = TTest)
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_ttest <- nem |>
              filter_name(meta, Treatments \%in\% c("CK", "C8")) |>
              calc_compare(.group = Treatments, y = Mesorhabditis, method = TTest)
nem_ttest
}
\seealso{
Other functions related to differential analysis methods: \code{\link{TTest2}},
\code{\link{WilcoxTest}}, \code{\link{WilcoxTest2}}, \code{\link{KruskalTest}},
\code{\link{KruskalTest2}}, \code{\link{LSD}}, \code{\link{LSD2}}, \code{\link{HSD}},
\code{\link{HSD2}}.
}
