% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_geoFacet}
\alias{e_geoFacet}
\title{Create geoFacet Echart}
\usage{
e_geoFacet(
  e,
  rows,
  cols,
  grid,
  legend = TRUE,
  legend_pos = "top",
  legend_space = "10\%",
  margin_trbl = c(t = "8\%", r = "5\%", b = "8\%", l = "8\%"),
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{rows, cols}{Provide integer values for the number of rows and columns in
the matrix grid}

\item{grid}{A custom grid containing row,col positions and name. Or a string
containing the name of a premade geoFacet grid from the geoFacet package.}

\item{legend}{Whether chart contains a legend. Defaults to \code{TRUE}.}

\item{legend_pos}{Position of the legend. One of "top", "right", "bottom",
"left". Determines to which side the `legend_space` argument applies.}

\item{legend_space}{Space between legend and plot area. Supports
integers(pixels) or strings(percent of parent cell).}

\item{margin_trbl}{Adjusts the size of the outside margin around the plotting
area. Default is `c(t = "15%", r = "5%", b = "5%", l = "5%")`. Supports
integers(pixels) or strings(percent of parent cell) To change only e.g. two
sides `c("r" = 8, "l" = 8)` could be used, other sides will use defaults.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
generates a faceted chart using matrix functionality. Provides similar
functionality to e_facet(). Similar to geoFacet package. Timeline is NOT
supported.
}
\examples{
if (require("geofacet", quietly = TRUE)) {
  library(geofacet)

  df <- data.frame(group = rep(letters[1:6], each = 20),
  date = seq(from = as.Date("2025-01-01"),
             to = as.Date("2025-01-20"), by = "day"),
  temp = sample(c(10:20), size = 60, replace = TRUE))
  grid <- data.frame(name = unique(df$group), row = c(1:6), col = c(1:6))

  df |>
    group_by(group) |>
    e_chart(date) |>
    e_line(temp, symbol = "none") |>
    e_x_axis(splitNumber = 2) |>
    e_y_axis(splitNumber = 2) |>
    e_geoFacet(legend = FALSE,
               grid = grid,
               margin_trbl = c("t"="25\%"),
               left = "5\%",
               width = "90\%") |>
    e_title(text = "Group Temps")


  tem <- data.frame(state.x77)
  sta <- cbind(state.name, tem)
  colnames(sta)[1] <- "State"

  sta |>
    group_by(State) |>
    e_charts(Population) |>
    e_scatter(Income) |>
    e_geoFacet(grid = "us_state_grid1") |>
    e_tooltip()
 }

}
