% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo.R
\name{echo}
\alias{echo}
\title{Echo}
\usage{
echo(
  expr,
  log = echo_get_log(),
  msg = echo_get_msg(),
  level = echo_get_level(),
  file = NULL
)
}
\arguments{
\item{expr}{Expression to evaluate; should be written with curly braces (see
examples)}

\item{log}{A connection or file name for outputs; defaults to \code{stdout()}}

\item{msg}{Logical, if \code{FALSE} does not output a message; defaults to \code{TRUE}}

\item{level}{Sets the echo level (see details); defaults to \code{0L}}

\item{file}{File path to evaluate (like \code{\link[base:source]{base::source()}}).  If \code{file} is not
\code{NULL}, then \code{expr} must be missing`}
}
\value{
Nothing, called for side-effects
}
\description{
Echo expression or a file
}
\details{
Levels of output can be controlled with \code{level}:

\describe{
\item{\code{0}}{\code{EXP}: logs expressions that were evaluated}
\item{\code{1}}{\code{OUT}: logs outputs from expressions}
\item{\code{2}}{\code{MSG}: logs messages}
\item{\code{3}}{\code{WRN}: logs warnings}
\item{\code{4}}{\code{ERR}: logs errors}
}

When set, all outputs at the \code{level} or below are run. Errors are always
logged as they will interrupt and stop the program.

Timestamps are printed in UTC by default.  To control this, set the option
value, such as \code{options(echo.timezone = "EST")}.
}
\examples{
# make sure to use braces for expr
echo(letters, level = 0)   # bad
echo({letters}, level = 0) # good

try(echo(
  expr = {
    print(1 + 1)
    Sys.sleep(2)
    head(mtcars)
    message(1)
    warning(2)
    stop(3)
  },
  level = 0
))


# Parse lines in a file instead
try(echo(file = system.file("example-script.R", package = "echo")))

# Note that
x <- c("example for", "writing lines")
echo({
  x
  print(x)
  writeLines(x)
}, level = 0)
}
