% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ed_get.R
\name{ed_get_tables}
\alias{ed_get_tables}
\title{List Parquet tables for a specific EconDataverse dataset}
\usage{
ed_get_tables(dataset, quiet = FALSE)
}
\arguments{
\item{dataset}{Character; the dataset repository name (e.g., "wbids").}

\item{quiet}{Logical; suppress messages? Default: FALSE.}
}
\value{
A data.frame with:
\describe{
\item{table}{Basename without the \code{.parquet} extension}
\item{filename}{Filename with extension}
\item{path}{Path within the repo}
\item{size}{File size}
\item{url}{Direct \code{resolve/main} URL to the Parquet file}
}
Returns \code{NULL} if the request fails.
}
\description{
Queries the Hugging Face Hub and returns all \code{.parquet} files
under a given dataset repository in the
\href{https://huggingface.co/econdataverse}{EconDataverse} organization,
including file sizes.
}
\examples{
\donttest{
ed_get_tables("wbids")
}

}
