% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{complexity_measures}
\alias{complexity_measures}
\title{Complexity Measures}
\usage{
complexity_measures(
  balassa_index,
  method = "fitness",
  iterations = 20,
  extremality = 1
)
}
\arguments{
\item{balassa_index}{(Type: matrix) the output from
\code{balassa_index()}) or an equivalent arrangement.}

\item{method}{(Type: character) one of these methods: fitness,
reflections or eigenvalues. By default this is set to \code{"fitness"}.}

\item{iterations}{(Type: numeric) the number of iterations to use.
By default this is set to \code{20}.}

\item{extremality}{(Type: numeric) the parameter to use in the fitness
method. The other methods don't use this parameter.
By default this is set to \code{1}.}
}
\value{
A list of two named numeric vectors.
}
\description{
\code{complexity_measures()} computes the Economic Complexity
Index and the Product Complexity Index.
}
\details{
The current implementation follows
\insertCite{measuringcomplexity2015}{economiccomplexity} to obtain different
alternatives that account for diversification in bipartite relations.
}
\examples{
co <- complexity_measures(economiccomplexity_output$balassa_index)

# partial view of indexes
n <- seq_len(5)
co$complexity_index_country[n]
co$complexity_index_product[n]

}
\references{
For more information on this index see:

\insertRef{measuringcomplexity2015}{economiccomplexity}

and the references therein.
}
\keyword{functions}
