% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_income_level_column}
\alias{add_income_level_column}
\title{Add Income Levels to Country Data}
\usage{
add_income_level_column(
  df,
  id_column,
  id_type = "iso3_code",
  target_column = "income_level"
)
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{id_type}{Type of country identifier. Defaults to "iso3_code".}

\item{target_column}{Name of the output column. Defaults to "income_level".}
}
\value{
A data frame with a additional columns containing the income level ID
and name.
}
\description{
Add Income Levels to Country Data
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# Add income levels using ISO3 codes
df <- data.frame(country = c("USA", "NGA", "IND"))
result <- add_income_level_column(df, id_column = "country")
}
\dontshow{\}) # examplesIf}
}
