% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique2.R
\name{unique2}
\alias{unique2}
\title{Internal Ecospace Functions.}
\usage{
unique2(x, length = 1, ...)
}
\arguments{
\item{x}{a vector or a data frame or an array or NULL.}

\item{length}{number of times (default = 1) to repeat the dimensionally shorter
state.}

\item{...}{arguments for particular methods.}
}
\description{
Internal functions not intended to be called directly by users.
}
\details{
Modified \code{unique} function that returns proper number of items for
filling of matrix when called within \code{apply}.
}
\note{
When dealing with ecospace frameworks with multistate binary (numeric)
  character types and characters weighted by supplied species pools,
  sometimes all species will share the same state value for one of several
  states. (For example, perhaps all species are capable of sexual
  reproduction, but there is variation in whether some are exclusively sexual
  and some are hermaphroditic.) When this occurs, calling \code{apply} when
  choosing possible ecospace states will 'break the dimensionality' of the
  character matrix and convert it into a list. This function maintains matrix
  dimensionality, by repeating the dimensionally shorter unique state
  sufficient times to maintain equal length as found in other states.
}
\seealso{
\code{\link[base]{unique}}
}
