% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.mlm.R
\name{simulate.mlm}
\alias{simulate.mlm}
\title{Simulate Responses from a Multivariate Linear Model}
\usage{
\method{simulate}{mlm}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{a \code{mlm} object, typically the result of calling \code{lm} 
where the response is a matrix.}

\item{nsim}{number of replicate datasets to simulate. If \code{nsim} is greater than 1,
the output is arranged in a 3D array.}

\item{seed}{an object specifying if and how the random number generator should be 
initialized (‘seeded’). Either NULL or an integer that will be used in a call to set.seed
before simulating the response vectors. If set, the value is saved as the "seed" attribute 
of the returned value. The default, NULL will not change the random generator state, and 
return .Random.seed as the "seed" attribute, see ‘Value’}

\item{...}{additional optional arguments.}
}
\value{
A matrix of simulated values for the response (or an array, for \code{nsim} greater than 1)
}
\description{
Simulate one or more sets of responses from a Multivariate Linear Model (\code{mlm}) object.
}
\details{
A \code{simulate} function for \code{mlm} objects, which simulates one or more 
sets of responses from a Multivariate Linear Model (\code{mlm}) object.
If multiple sets of responses are requested, they are returned in a 3D array,
with simulation number along the third dimension.

The weights argument is currently ignored -- a constant 
variance-covariance matrix assumed for \code{mlm}.
}
\examples{
# fit a mlm to iris data:
data(iris)
iris.mlm=lm(cbind(Sepal.Length,Sepal.Width,Petal.Length,Petal.Width)~Species,data=iris)
# simulate new responses:
simulate(iris.mlm)

}
\seealso{
\code{\link{lm}}, \code{\link{simulate}}
}
\author{
David Warton <david.warton@unsw.edu.au>
}
