% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.recombinator.sbx.R
\name{recSBX}
\alias{recSBX}
\title{Simulated Binary Crossover (SBX) recombinator.}
\usage{
recSBX(inds, eta = 5, p = 1, lower, upper)
}
\arguments{
\item{inds}{[\code{numeric}]\cr
Parents, i.e., list of exactly two numeric vectors of equal length.}

\item{eta}{[\code{numeric(1)}]\cr
Parameter eta, i.e., the distance parameters of the crossover distribution.}

\item{p}{[\code{numeric(1)}]\cr
Crossover probability for each gene. Default is \code{1.0}.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space.}
}
\value{
[\code{ecr_recombinator}]
}
\description{
The Simulated Binary Crossover was first proposed by [1]. It i suited for
float representation only and creates two offspring. Given parents \eqn{p_1, p_2}
the offspring are generated as \eqn{c_{1/2} = \bar{x} \pm \frac{1}{2}\beta(p_2 - p_1)}
where \eqn{\bar{x} = \frac{1}{2}(p_1 + p_2), p_2 > p_1}. This way \eqn{\bar{c} = \bar{x}}
is assured.
}
\note{
This is the default recombination operator used in the NSGA-II EMOA (see \code{\link{nsga2}}).
}
\references{
[1] Deb, K. and Agrawal, R. B. (1995). Simulated binary crossover for continuous
search space. Complex Systems 9(2), 115-148.
}
\seealso{
Other recombinators: 
\code{\link{recCrossover}()},
\code{\link{recIntermediate}()},
\code{\link{recOX}()},
\code{\link{recPMX}()},
\code{\link{recUnifCrossover}()}
}
\concept{recombinators}
