% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{test_ollama_model_compatibility}
\alias{test_ollama_model_compatibility}
\title{Test if an Ollama model blob can be used with edgemodelr}
\usage{
test_ollama_model_compatibility(model_path, verbose = FALSE)
}
\arguments{
\item{model_path}{Path to the Ollama blob file (a GGUF file, typically
named by its SHA-256 hash inside the Ollama models/blobs directory).}

\item{verbose}{If TRUE, print human-readable diagnostics for models
that fail the compatibility checks.}
}
\value{
Logical: TRUE if the model loads and can run a short
completion successfully, FALSE otherwise.
}
\description{
This function tries to load an Ollama GGUF blob with edgemodelr using a
minimal configuration and then runs a very short completion. It is intended
to quickly detect common incompatibilities (unsupported architectures,
invalid or unsupported GGUF files, or models that cannot run inference)
before you attempt to use the model in a longer session.
}
\details{
A model is considered compatible if:
\itemize{
\item \code{edge_load_model()} succeeds with a small context size
(\code{n_ctx = 256}) and CPU-only execution (\code{n_gpu_layers = 0}),
\item the resulting model context passes \code{is_valid_model()},
\item and a minimal call to \code{edge_completion()} (1 token) returns
without error.
}

When \code{verbose = TRUE}, this function classifies common failure modes:
unsupported model architecture, invalid GGUF file, unsupported GGUF version,
or a generic error (first 80 characters reported with truncation indicator).
}
\examples{
\dontrun{
# Test an individual Ollama blob
# is_ok <- test_ollama_model_compatibility("/path/to/blob", verbose = TRUE)
#
# This function is also used internally by edge_find_ollama_models()
# when test_compatibility = TRUE.
}
}
