% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etheil.R
\name{etheil}
\alias{etheil}
\title{Theil index of education}
\usage{
etheil(countries, init.y, final.y, database, plot = TRUE)
}
\arguments{
\item{countries}{character vector with the country codes of the countries
to be used. Some macro-regions are already defined and can be used
instead of the country codes: \code{South Asia, Europe and Central Asia,
Middle East and North Africa, Latin America and the Caribbean, Advanced
Economies, Sub-Saharan Africa, East Asia and the Pacific} and \code{all}
for the 142 counrties included in the dataset.(see \code{data_country}).}

\item{init.y}{the first year in which the function is calculated. Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{final.y}{the last year in which the function is calculated Available
years are 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010.}

\item{database}{population subgrup for which the function is calculated.
The following options are available:
\enumerate{
  \item \code{"total15"}: Total population aged over-15.
  \item \code{"total25"}: Total population aged over-25.
  \item \code{"male15"}: Male population aged over-15.
  \item \code{"male25"}: Male population aged over-25.
  \item \code{"female15"}: Female population aged over-15.
  \item \code{"female25"}: Female population aged over-25.
}}

\item{plot}{if \code{TRUE} (the default), displays a graph of the results.}
}
\value{
\code{etheil} returns a list with the following objects:
  \enumerate{
  \item \code{Theli_index}: evolution of the Theil index of education
    from the initial to the last year, decomposed in between-country
    and within-country inequality.
  \item \code{countries}: countries used to compute the Theil index.
  \item If \code{plot = TRUE}, graphical representation of the numerical results.
  }
}
\description{
\code{etheil} is a function to compute the Theil index of education for any group of
countries included in the dataset developed in Jorda and Alonso (2017).
The function also provides a decomposition of this index in between-county
and within-country inequality.
}
\details{
The estimates of the Theil index for the specified group of countries
can be easily derived by taking advantage of the decomposition of this family.
It is computed as the sum of the following terms, which correspond to within-
country and between, country inequality respectively (see, e.g., Cowell, 2011):

\eqn{T_W=\sum_{i=1}^{N} s_i T_i;}

\eqn{T_B=\sum_{i=1}^{N} s_i log(\mu_i / \mu),}

where \emph{N} is the number of countries, \eqn{T_i} denotes the Theil index
of the country \emph{i} and \eqn{s_i} stands for the proportion of mean income
of the country \emph{i} in the overall mean of the group:
\eqn{s_i=\lambda_i \mu_i / \sum_{i=1}^{N} \lambda_i \mu_i}.
}
\examples{
etheil(countries = "Advanced Economies", init.y = 1980, final.y = 2000,
       database = "male25")
etheil(countries = c("DNK", "FIN", "ISL", "NOR", "SWE"), init.y = 1980,
       final.y = 2000, database = "female15")
}
\references{
Cowell, F. (2011). Measuring inequality. Oxford University Press.

Jorda, V. and Alonso, J.M. (2017). New estimates on educational
 attainment using a continuous approach (1970-2010), World Development,
 90, 281 - 293.
 \url{http://www.sciencedirect.com/science/article/pii/S0305750X16305010}
}
\seealso{
\code{\link{data_country}}. Visit \url{http://www.educationdata.unican.es}
  for more information on the constructoin of the dataset and the available
  \href{http://www.educationdata.unican.es/countries}{countries}.
}

