% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_performance.R
\name{mean_beta}
\alias{mean_beta}
\title{Average Estimated Coefficient}
\usage{
mean_beta(df)
}
\arguments{
\item{df}{A data frame of replicated simulations which must include a column
titled "Estimate" with the effect estimate from the fitted model.}
}
\value{
A data frame with the mean estimated log relative risk and mean estimated
   relative risk. The mean estimated risk is based on first calculating the
   mean log relative risk and then exponentiating this mean value.
}
\description{
This function gives the mean value of the estimated log relative risks (\eqn{\hat{\beta}}s)
and the mean of the estimated relative risk values over the \code{n} simulations.
}
\examples{
sims <- create_sims(n_reps=10, n=50, central = 100, sd = 10,
            exposure_type="continuous", exposure_trend = "cos1",
            exposure_amp = .6, average_outcome = 22,
            outcome_trend = "no trend", outcome_amp = .6, rr = 1.01)
fits <- fit_mods(data = sims, custom_model = spline_mod,
                 custom_model_args = list(df_year = 1))
mean_beta(df=fits)

}
