% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eiopaR.R
\name{get_rfr}
\alias{get_rfr}
\title{Query EIOPA risk-free rate (RFR).}
\usage{
get_rfr(
  type = options_rfr_types(),
  region,
  year = NULL,
  month = NULL,
  format = c("data.frame")
)
}
\arguments{
\item{type}{the type of the risk-free rate, see \code{options_rfr_types()} for the different options (examples: "with_va", "no_va").}

\item{region}{the region to query (examples: "FR". see \code{get_options("region")}).}

\item{year}{the year of the RFR.}

\item{month}{the month of the RFR.}

\item{format}{the format for the output data. Currently the only option is "data.frame".}
}
\value{
A list of class "eiopa_rfr", with components:
\describe{
\item{data}{a data.frame containing the risk-free rate curves.}
\item{metadata}{a data.frame containing metadata about the risk-free rate curves.}
}
}
\description{
This function query and returns the EIOPA risk-free interest rate term structures from an API.

Note: this function is getting the data from an API. Your IP can be temporary or permanently blocked if too many queries are executed.

For optimal performance, we recommend to limit the number of calls to this function.

EIOPA website : https://www.eiopa.europa.eu/tools-and-data/risk-free-interest-rate-term-structures_en
}
\examples{
\dontrun{
get_rfr("with_va", "FR", 2019, 12)
get_rfr("no_va", "FR", c(2016, 2019), 12)
}
}
\seealso{
get_rfr_with_va, get_rfr_no_va
}
