% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_test.R
\name{el_test}
\alias{el_test}
\title{Hypothesis testing with empirical likelihood}
\usage{
el_test(
  formula,
  data,
  lhs,
  rhs = NULL,
  maxit = 10000,
  abstol = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} (or one that can be coerced to that class)
for a symbolic description of the model to be fitted. It must specify the
variables for response, treatment, and block as \code{response ~ treatment | block}. Note that the use of vertical bar (\code{|}) separating treatment and
block.}

\item{data}{A data frame containing the variables in \code{formula}.}

\item{lhs}{A numeric matrix specifying the left-hand side of a hypothesis in terms of
parameters.}

\item{rhs}{An optional numeric vector specifying the right-hand side the hypothesis.
If not specified, it is set to the zero vector. Defaults to \code{NULL}.}

\item{maxit}{A single integer for the maximum number of iterations for optimization.
Defaults to \code{10000}.}

\item{abstol}{A single numeric for the absolute convergence tolerance for optimization.
Defaults to \code{1e-08}.}

\item{verbose}{A single logical. If \code{TRUE}, a message on the convergence status is
printed. Defaults to \code{FALSE}.}
}
\value{
A list containing the model fit and optimization results.
}
\description{
Tests single hypothesis for general block designs with empirical
likelihood.
}
\examples{
# Test for equal means
data("clothianidin")
el_test(clo ~ trt | blk, clothianidin,
  lhs = matrix(c(
    1, -1, 0, 0,
    0, 1, -1, 0,
    0, 0, 1, -1
  ), byrow = TRUE, nrow = 3L)
)
}
\references{
Kim E, MacEachern SN, Peruggia M (2023).
"Empirical likelihood for the analysis of experimental designs."
\emph{Journal of Nonparametric Statistics}, \strong{35}(4), 709--732.
\doi{10.1080/10485252.2023.2206919}.
}
