% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_functions.R
\name{create_ylt}
\alias{create_ylt}
\title{Create a YLT from ELT via monte carlo simulation}
\usage{
create_ylt(dt, sims, ann_rate, event_id, expval, mu)
}
\arguments{
\item{dt}{a data.table with modified ELT}

\item{sims}{number of years to simulate}

\item{ann_rate}{event frequency}

\item{event_id}{unique event identifier}

\item{expval}{total amount exposed}

\item{mu}{mean event loss}
}
\value{
a tidy data.table with Loss, Year and ID. Where a year simulated with zero events will show as "none"
}
\description{
Create a YLT from ELT via monte carlo simulation
}
\examples{
create_ylt(create_elt(eltr::example_elt, ann_rate="rate", mu="mean", 
      sdev_i = "sdevi" , sdev_c = "sdevc", expval="exp"),
      sims=10,ann_rate = "rate" ,event_id = "id",expval = "exp",mu ="mean")
}
