\name{addnoise}
\alias{addnoise}

\title{Creates random errors for use in power.trend.}

\description{
This function is used within \code{\link{power.trend}}.
Distribution of noise can be either Normal, Poisson or Negative Binomial. The mean values are entered
as a parameter (possibly generated by function \code{\link{generate.trend}}). Other parameters (\code{sd} for Normal,
\code{nbsize}
for Negative Binomial) need to be given. Values in \code{meanvalues} are used as the mean values for one of the three
specified distributions and then a random allocation is made for each of the \code{nobs} values, where \code{nobs} is the
length of \code{meanvalues}.
}
\usage{
addnoise(meanvalues, reps, distribution, sd, nbsize, randeffect, randeffect.sd) 
}
\arguments{
  \item{meanvalues}{ Vector of mean values}
  \item{reps}{Number of replicates per time point}
  \item{distribution}{ Character string which must be one of \code{Normal} (default), \code{Poisson} or \code{Negbin}} 
  \item{sd}{ Standard Deviation for Normal distribution}
  \item{nbsize}{ Size parameter for Negative Binomial distribution}
  \item{randeffect}{Not working yet}
  \item{randeffect.sd}{Not working yet}
}

\value{
Output is a vector of the same length as \code{meanvalues}.
}

\author{
David Maxwell: David.Maxwell@cefas.co.uk
}
\seealso{
\code{\link{generate.trend}}, \code{\link{power.trend}}
}


