% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{stability.plot}
\alias{stability.plot}
\title{Stability plot}
\usage{
stability.plot(x, umin = quantile(na.omit(x), probs = 0.8),
  umax = quantile(na.omit(x), probs = 0.95),
  kmin = round(length(na.omit(x)) * 0.05),
  kmax = round(length(na.omit(x)) * 0.2), nint = 100, conf = 0.95,
  est.method = "mle", u0 = NULL, k0 = NULL)
}
\arguments{
\item{x}{data values.
Supported data types
\itemize{
  \item{a numeric vector}
  \item{a time series object \code{ts}}
  \item{a time series object \code{xts}}
  \item{a time series object \code{zoo}}
}}

\item{umin}{the minimum threshold at which the mean residual life function is calculated. Default is \code{umin = quantile(na.omit(x), probs = 0.8)}.}

\item{umax}{the maximum threshold at which the mean residual life function is calculated. Default is \code{ummax = quantile(na.omit(x), probs = 0.95)}.}

\item{kmin}{the minimum number of largest order statistics for which the mean residual life function is calculated based on moment estimates. Default is \code{kmin = round(length(na.omit(x)) * 0.05)}.}

\item{kmax}{the maximum number of largest order statistics for which the mean residual life function is calculated based on moment estimates. Default is \code{kmax = round(length(na.omit(x)) * 0.2)}.}

\item{nint}{the number of points at which the mean residual life function is calculated. Default is \code{nint = 100}.}

\item{conf}{the confidence coefficient for the confidence intervals depicted in the plot. Default is \code{conf = 0.95}.}

\item{est.method}{a character string specifying the type of estimates for the scale and shape parameters of GP distribution.

Possible options are
\itemize{
  \item{\code{"mle"}} {(default) to use maximum likelihood estimates (Coles, 2001)}
  \item{\code{"moment"}} {to use moment estimates (de Haan and Ferreira, 2006).}
}}

\item{u0}{a numeric value giving the threshold meant for a GP approximation of the threshold exceedances. Default is \code{u0 = NULL}.}

\item{k0}{a numeric value giving the number \code{(k0-1)} of largest observations meant for a GP approximation. Default is \code{k0 = NULL}.}
}
\description{
A stability plot for maximum likelihood or moment estimates of the GP parameters (Coles, 2001), including confidence intervals, at a range of thresholds or number of the largest observations.
}
\details{
The function estimates the GP parameters at a range of thresholds (in case \code{est.method = "mle"}) or a range of upper order statistics (in case of \code{est.method = "moment"}), and shows the sample paths of the estimates.
The estimates of the shape or the scale parameter are expected to be constant or to change linearly, respectively, with threshold levels at which the GP model is appropriate.
If \code{u0} (or \code{k0}, respectively) is given, a threshold-dependency lines for the particular parameters are plotted in addition. The lines provide the user an option to assess the suitability of \code{u0} or \code{k0} as a lower bound for the threshold exceedances (for \code{u0}) or the number of upper order statistics (for \code{k0}) to fit the GP distribution.
In case \code{est.method = "mle"} and \code{u0} takes a value, the theoretical dependency lines for the parameters are evaluated on the basis of MLE estimates. For the case \code{est.method = "moment"} and \code{k0} is given, the dependency lines are estimated using the moment estimators.
In case \code{est.method = "moment"} the value \code{x(n-k)} on the x-axis of MRL plot denotes the \code{(k + 1)}-th largest observation of the total number of \code{n} observations.
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
res = smoothing(y = x)$residuals
stability.plot(res)
}
\references{
Theo Gasser, Alois Kneip & Walter Koehler (1991) A flexible and fast method for automatic smoothing. Journal of the American Statistical Association 86, 643-652. https://doi.org/10.2307/2290393

E. Herrmann (1997) Local bandwidth choice in kernel regression estimation. Journal of Graphical and Computational Statistics 6, 35-54.

Herrmann E, Maechler M (2013). lokern: Kernel Regression Smoothing with Local or Global Plug-in Bandwidth. R package version 1.1-5, URL http://CRAN.R-project.org/package=lokern.

Gasser, T, Muller, H-G, Mammitzsch, V (1985). Kernels for nonparametric curve estimation. Journal of the Royal Statistical Society, B Met., 47(2), 238-252.

Coles, S (2001). An Introduction to Statistical Modeling of Extreme Values. Springer-Verlag, London, U.K., 208pp.

de Haan, L, Ferreira, A (2006). Extreme Value Theory: An Introduction. Springer.
}
