% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.check_statistic_args}
\alias{.check_statistic_args}
\title{Check that the \code{statistic} and \code{stat_threshold} arguments are valid}
\usage{
.check_statistic_args(statistic, stat_threshold)
}
\arguments{
\item{statistic}{The chain statistic to track as the
stopping criteria for each chain being simulated when \code{stat_threshold} is not
\code{Inf}; A \verb{<string>}. It can be one of:
\itemize{
\item "size": the total number of cases produced by a chain before it goes
extinct.
\item "length": the total number of generations reached by a chain before
it goes extinct.
}}

\item{stat_threshold}{A stopping criterion for individual chain simulations;
a positive number coercible to integer. When any chain's cumulative statistic
reaches or surpasses \code{stat_threshold}, that chain ends. Defaults to \code{Inf}.
For example, if \code{statistic = "size"} and \code{stat_threshold = 10}, then any
chain that produces 10 or more cases will stop. Note that setting
\code{stat_threshold} does not guarantee that all chains will stop at the same
value.}
}
\value{
NULL; called for side effects
}
\description{
The function treats these two arguments as related and checks
them in one place to remove repeated checks in several places in the
package.
}
\keyword{internal}
