% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_params.R
\name{.convert_params_geom}
\alias{.convert_params_geom}
\title{Convert parameter of the geometric distribution to summary statistics}
\usage{
.convert_params_geom(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{Numeric} named parameter(s)
used to convert to summary statistics. An example is the \code{meanlog} and
\code{sdlog} parameters of the lognormal (\code{lnorm}) distribution.}
}
\value{
A list of eight elements including: mean, median, mode,
variance (\code{var}), standard deviation (\code{sd}), coefficient of variation (\code{cv}),
skewness, and excess kurtosis (\code{ex_kurtosis}).
}
\description{
Convert the probability (\code{prob}) of the geometric distribution
to a number of summary statistics which can be calculated analytically given
the geometric parameter. One exception is the median which is calculated
using \code{\link[stats:Geometric]{stats::qgeom()}} as the analytical form is not always unique.
}
\details{
This conversion function assumes that distribution represents the
number of failures before the first success (supported for zero). This is
the same form as used by base R and \code{\link[distributional:dist_geometric]{distributional::dist_geometric()}}.
}
\keyword{internal}
