% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betabinom.R
\name{BetaBinomial}
\alias{BetaBinomial}
\alias{dbetabinom}
\alias{pbetabinom}
\alias{qbetabinom}
\alias{rbetabinom}
\title{The beta-binomial distribution.}
\usage{
dbetabinom(x, size, prob, theta, shape1, shape2, log = FALSE)

pbetabinom(
  q,
  size,
  prob,
  theta,
  shape1,
  shape2,
  lower.tail = TRUE,
  log.p = FALSE
)

qbetabinom(
  p,
  size,
  prob,
  theta,
  shape1,
  shape2,
  lower.tail = TRUE,
  log.p = FALSE
)

rbetabinom(n, size, prob, theta, shape1, shape2)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{size}{Number of trials.}

\item{prob}{Probability of success on each trial.}

\item{theta}{Aggregation parameter (theta = 1 / (shape1 + shape2)).}

\item{shape1, shape2}{Shape parameters.}

\item{log, log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{Logical; if TRUE (default), probabilities are
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations.}
}
\value{
\code{dbetabinom} gives the density, \code{pbetabinom} gives the distribution
function, \code{qbetabinom} gives the quantile function and \code{rbetabinom}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the beta-binomial distribution with parameters \code{size}, \code{prob},
\code{theta}, \code{shape1}, \code{shape2}. This distribution corresponds to
an overdispersed binomial distribution.
}
\details{
Be aware that in this implementation \code{theta} = 1 / (\code{shape1} +
\code{shape2}). \code{prob} and \code{theta}, or \code{shape1} and
\code{shape2} must be specified. if \code{theta} = 0, use *binom family
instead.
}
\examples{
# Compute P(25 < X < 50) for X following the Beta-Binomial distribution
# with parameters size = 100, prob = 0.5 and theta = 0.35:
sum(dbetabinom(25:50, size = 100, prob = 0.5, theta = 0.35))

# When theta tends to 0, dbetabinom outputs tends to dbinom outputs:
sum(dbetabinom(25:50, size = 100, prob = 0.5, theta = 1e-7))
sum(dbetabinom(25:50, size = 100, shape1 = 1e7, shape2 = 1e7))
sum(dbinom(25:50, size = 100, prob = 0.5))

# Example of binomial and beta-binomial frequency distributions:
n   <- 15
q   <- 0:n
p1  <- dbinom(q, size = n, prob = 0.33)
p2  <- dbetabinom(q, size = n, prob = 0.33, theta = 0.22)
res <- rbind(p1, p2)
dimnames(res) <- list(c("Binomial", "Beta-binomial"), q)
barplot(res, beside = TRUE, legend.text = TRUE, ylab = "Frequency")

# Effect of the aggregation parameter theta on probability density:
thetas <- seq(0.001, 2.5, by = 0.001)
density1 <- rep(sum(dbinom(25:50, size = 100, prob = 0.5)), length(thetas))
density2 <- sapply(thetas, function(theta) {
    sum(dbetabinom(25:50, size = 100, prob = 0.5, theta = theta))
})
plot(thetas, density2, type = "l",
     xlab = expression("Aggregation parameter ("*theta*")"),
     ylab = "Probability density between 25 and 50 (size = 100)")
lines(thetas, density1, lty = 2)

}
\seealso{
\code{\link[emdbook]{dbetabinom}} in the package \strong{emdbook}
where the definition of theta is different.
}
