% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{citrus_ctv}
\alias{citrus_ctv}
\title{Incidence of citrus tristeza virus (CTV) disease in three fields.}
\format{
There are three data frames:
\itemize{
    \item \code{IVI3and4}: A data frame with 864 rows and 5 variables.
    \item \code{IVI6and7}: A data frame with 648 rows and 5 variables.
    \item \code{El_Realengo}: A data frame with 2000 rows and 5 variables.
}

The structure is the same for all the data frames:

\tabular{rll}{
    [, 1:2] \tab x,y \tab Grid spatial coordinates. \cr
    [, 3]   \tab t   \tab Year of disease assessments. \cr
    [, 4]   \tab i   \tab Disease incidence. 0: Healthy, 1: Diseased. \cr
    [, 5]   \tab n   \tab Sampling unit size. n = 1 means that the sampling
                          unit size is the plant. \cr
}
}
\source{
Gottwald TR, Cambra M, Moreno P, Camarasa E, Piquer J. 1996. Spatial
    and temporal analyses of citrus tristeza virus in eastern Spain.
    Phytopathology 86, 45–55.

Gibson GJ. 1997. Investigating mechanisms of spatiotemporal epidemic
    spread using stochastic models. Phytopathology 87, 139-46.
    \doi{10.1094/PHYTO.1997.87.2.139}
}
\usage{
citrus_ctv
}
\description{
CTV incidence data for three orchards in eastern Spain reported for
consecutive years.
}
\details{
Both \code{IVI3and4} and \code{IVI6and7} orchards consisted of 216 trees each
of Washington navel orange on Troyer citrange planted in 1978 on a 2 x 6-m
spacing. \code{El_Realengo} orchard consisted of 400 Marsh seedless
grapefruit on Troyer citrange planted in 1973 on a 5.5 x 5.5-m spacing.
}
\keyword{datasets}
