% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_preport_month_crosssections}
\alias{epitrax_preport_month_crosssections}
\title{Create monthly cross-section reports from an EpiTrax object}
\usage{
epitrax_preport_month_crosssections(epitrax, month_offsets = 0:3)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{month_offsets}{Numeric vector of month offsets to create reports for.
Defaults to 0:3, which generates reports for the current month and the three
previous months.}
}
\value{
Updated EpiTrax object with monthly cross-section reports added to
the \code{public_reports} field.
}
\description{
\code{epitrax_preport_month_crosssections} generates monthly cross-section
reports. These compare the counts for a given month against the
monthly averages for the same month across previous years.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_preport_month_crosssections(month_offsets = 0:1)

names(epitrax$public_reports)
}
