% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{read_epitrax_data}
\alias{read_epitrax_data}
\title{Read in EpiTrax data}
\usage{
read_epitrax_data(filepath = NULL, num_yrs = 5)
}
\arguments{
\item{filepath}{Optional filepath. Data file should be a CSV. If this parameter
is NULL, the user will be prompted to choose a file interactively.}

\item{num_yrs}{Integer. Number of years of data to keep. Defaults to 5.}
}
\value{
The validated and formatted EpiTrax data from the input file.
}
\description{
'read_epitrax_data' reads EpiTrax data from a CSV, validates, and formats it.
It also filters rows older than given number of years. The input file must
contain the columns:
\itemize{
\item \code{patient_mmwr_year} (integer)
\item \code{patient_mmwr_week} (integer)
\item \code{patient_disease} (character)
}
}
\details{
See the example file here:
\code{system.file("sample_data/sample_epitrax_data.csv", package = "epitraxr")}
}
\examples{
if(interactive()) {
  # Interactive file chooser:
  read_epitrax_data()
}

# Using a file path:
data <- read_epitrax_data(
  filepath = system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr"),
  num_yrs = 3
)
head(data)
}
