% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{engine_pick}
\alias{engine_pick}
\title{Pick an engine-specific value}
\usage{
engine_pick(md, html = md, latex = md)
}
\arguments{
\item{md, html, latex}{The value to use in a markdown, HTML, or LaTeX context.}
}
\value{
The value of \code{md}, \code{html} or \code{latex} depending on the epoxy or knitr
currently being evaluated.
}
\description{
Set different values that will be used based on the current epoxy or knitr
engine (one of \code{md}, \code{html}, or \code{latex}). The engine-specific value will be
used inside epoxy knitr chunks or epoxy functions matching the source syntax:
\code{\link[=epoxy]{epoxy()}} (\code{md}), \code{\link[=epoxy_html]{epoxy_html()}} (\code{html}), or \code{\link[=epoxy_latex]{epoxy_latex()}} (\code{latex}).
}
\examples{
# Markdown and HTML are okay with bare `$` character,
# but we need to escape it in LaTeX.
engine_pick(md = "$", latex = "\\\\$")

}
