% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epoxy_mustache.R
\name{epoxy_mustache}
\alias{epoxy_mustache}
\title{Mustache-style string interpolation}
\usage{
epoxy_mustache(
  ...,
  .data = parent.frame(),
  .sep = "\\n",
  .vectorized = inherits(.data, "data.frame"),
  .partials = list()
)
}
\arguments{
\item{...}{A string or a vector of strings containing the template(s). Refer
to the \href{http://mustache.github.io/}{mustache documentation} for an overview
of the syntax. If multiple strings are passed, they are collapsed with
\code{.sep} (\code{"\\n"} by default).}

\item{.data}{A data frame or a list. If \code{.data} is a data frame,
\code{epoxy_mustache()} will transform the data frame so that the template can
be applied to each row of the data frame. To avoid this transformation,
wrap the \code{.data} value in \code{I()}.}

\item{.sep}{The separator to use when collapsing multiple strings passed in
\code{...} into a single template. Defaults to \code{"\\n"}.}

\item{.vectorized}{If \code{TRUE} , \code{epoxy_mustache()} will vectorize over the
items in \code{.data}. In other words, each item or row of \code{.data} will be used
to render the template once. By default, \code{.vectorized} is set to \code{TRUE} if
\code{.data} is a data frame and \code{FALSE} otherwise.}

\item{.partials}{A named list with partial templates. See
\code{\link[whisker:whisker.render]{whisker::whisker.render()}} or the \href{http://mustache.github.io/mustache.5.html#Partials}{mustache documentation} for
details.}
}
\value{
A character vector of length 1 if \code{.vectorized} is \code{FALSE} or a
character vector of the same length as the number of rows or items in
\code{.data} if \code{.vectorized} is \code{TRUE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A wrapper around the \href{http://mustache.github.io/}{mustache templating language}, provided by the
\href{https://cran.r-project.org/package=whisker}{whisker} package. Under the
hood, \code{epoxy_mustache()} uses \code{\link[whisker:whisker.render]{whisker::whisker.render()}} to render the
template, but adds a few conveniences:
\itemize{
\item The template can be passed in \code{...} as a single string, several strings or
as a vector of strings. If multiple strings are passed, they are collapsed
with \code{.sep} (\code{"\\n"} by default).
\item \code{epoxy_mustache()} can be vectorized over the items in the \code{.data}
argument. If \code{.data} is a data frame, vectorization is turned on by default
so that you can  iterate over the rows of the data frame. The output will
be a character vector of the same length as the number of rows in the data
frame.
}
}
\examples{
# The canonical mustache example
epoxy_mustache(
  "Hello {{name}}!",
  "You have just won {{value}} dollars!",
  "{{#in_ca}}",
  "Well, {{taxed_value}} dollars, after taxes.",
  "{{/in_ca}}",
  .data = list(
    name = "Chris",
    value = 10000,
    taxed_value = 10000 - (10000 * 0.4),
    in_ca = TRUE
  )
)

# Vectorized over the rows of .data
epoxy_mustache(
	"mpg: {{ mpg }}",
	"hp: {{ hp }}",
	"wt: {{ wt }}\n",
	.data = mtcars[1:2, ]
)

# Non-vectorized
epoxy_mustache(
	"mpg: {{ mpg }}",
	"hp: {{ hp }}",
	"wt: {{ wt }}",
	.data = mtcars[1:2, ],
  .vectorized = FALSE
)

# With mustache partials
epoxy_mustache(
  "Hello {{name}}!",
	"{{> salutation }}",
  "You have just won {{value}} dollars!",
  "{{#in_ca}}",
  "Well, {{taxed_value}} dollars, after taxes.",
  "{{/in_ca}}",
	.partials = list(
		salutation = c("Hope you are well, {{name}}.")
	),
	.sep = " ",
  .data = list(
    name = "Chris",
    value = 10000,
    taxed_value = 10000 - (10000 * 0.4),
    in_ca = TRUE
  )
)


}
\seealso{
Other Mustache-style template functions: 
\code{\link{ui_epoxy_mustache}()}
}
\concept{Mustache-style template functions}
