% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pconnorm.r
\name{pconnorm}
\alias{pconnorm}
\title{pconnorm .}
\usage{
pconnorm(y, A, b, eta, mu = NULL, Sigma = NULL, Sigma_eta = Sigma
  \%*\% eta, eta_mu = as.numeric(t(eta) \%*\% mu), lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{y}{an \eqn{n} vector, assumed multivariate normal with mean \eqn{\mu}
and covariance \eqn{\Sigma}.}

\item{A}{an \eqn{k \times n} matrix of constraints.}

\item{b}{a \eqn{k} vector of inequality limits.}

\item{eta}{an \eqn{n} vector of the test contrast, \eqn{\eta}.}

\item{mu}{an \eqn{n} vector of the population mean, \eqn{\mu}.
Not needed if \code{eta_mu} is given.}

\item{Sigma}{an \eqn{n \times n} matrix of the population covariance, \eqn{\Sigma}.
Not needed if \code{Sigma_eta} is given.}

\item{Sigma_eta}{an \eqn{n} vector of \eqn{\Sigma \eta}.}

\item{eta_mu}{the scalar \eqn{\eta^{\top}\mu}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
The CDF.
}
\description{
CDF of the conditional normal variate.
}
\details{
Computes the CDF of the truncated normal conditional
on linear constraints, as described in section 5 of Lee \emph{et al.}

Let \eqn{y} be multivariate normal with mean \eqn{\mu}
and covariance \eqn{\Sigma}. Conditional on \eqn{Ay \le b}{Ay <= b}
for conformable matrix \eqn{A} and vector \eqn{b} we compute the
CDF of a truncated normal maximally aligned with \eqn{\eta}. 
Inference depends on the population parameters only via 
\eqn{\eta^{\top}\mu}{eta'mu} and \eqn{\Sigma \eta}{Sigma eta},
and only these need to be given.

The test statistic is aligned with \eqn{y}, meaning that an output
p-value near one casts doubt on the null hypothesis that 
\eqn{\eta^{\top}\mu}{eta'mu} is less than the posited value.
}
\note{
An error will be thrown if we do not observe \eqn{A y \le b}{A y <= b}.
}
\references{
Lee, J. D., Sun, D. L., Sun, Y. and Taylor, J. E. "Exact post-selection inference, 
with application to the Lasso." Ann. Statist. 44, no. 3 (2016): 907-927.
doi:10.1214/15-AOS1371. \url{https://arxiv.org/abs/1311.6238}
}
\seealso{
the confidence interval function, \code{ci_connorm}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
