% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptruncnorm.r
\name{ptruncnorm}
\alias{ptruncnorm}
\title{ptruncnorm .}
\usage{
ptruncnorm(q, mean = 0, sd = 1, a = -Inf, b = Inf,
  lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{a}{vector of the left truncation value(s).}

\item{b}{vector of the right truncation value(s).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
The distribution function of the truncated normal.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Cumulative distribution of the truncated normal function.
}
\note{
Input are recycled as possible.
}
\examples{
y <- ptruncnorm(seq(-5,5,length.out=101), a=-1, b=2)
}
\references{
Hattaway, James T. "Parameter estimation and hypothesis testing for the truncated normal distribution 
with applications to introductory statistics grades." BYU Masters Thesis (2010).
\url{https://scholarsarchive.byu.edu/cgi/viewcontent.cgi?referer=&httpsredir=1&article=3052&context=etd}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
