% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{Curve-ergmTerm}
\alias{Curve-ergmTerm}
\alias{InitErgmTerm.Curve}
\alias{InitErgmTerm.Parametrise}
\alias{Parametrise-ergmTerm}
\alias{InitErgmTerm.Parametrize}
\alias{Parametrize-ergmTerm}
\alias{InitWtErgmTerm.Curve}
\alias{InitWtErgmTerm.Parametrise}
\alias{InitWtErgmTerm.Parametrize}
\title{Impose a curved structure on term parameters}
\usage{
# binary: Curve(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf, cov=NULL)

# binary: Parametrise(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf,
#           cov=NULL)

# binary: Parametrize(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf,
#           cov=NULL)

# valued: Curve(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf, cov=NULL)

# valued: Parametrise(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf,
#           cov=NULL)

# valued: Parametrize(formula, params, map, gradient=NULL, minpar=-Inf, maxpar=+Inf,
#           cov=NULL)
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}

\item{params}{a named list whose names are the curved parameter names, may also be a character vector with names.}

\item{map}{the mapping from curved to canonical. May have the following forms:
\itemize{
\item a \verb{function(x, n, ...)} treated as in the API: called with \code{x} set to the curved parameter vector, \code{n} to the length of output expected, and \code{cov} , if present, passed in \code{...} . The function must return a numeric vector of length \code{n} .
\item a numeric vector to fix the output coefficients, like in an offset.
\item a character string to select (partially-matched) one of predefined forms. Currently, the defined forms include:
\itemize{
\item \code{"rep"} recycle the input vector to the length of the output vector as a \code{rep} function would.
}
}}

\item{gradient}{its gradient function. It is optional if \code{map} is constant or one of the predefined forms; otherwise it must have one of the following forms:
\itemize{
\item a \verb{function(x, n, ...)} treated as in the API: called with \code{x} set to the curved parameter vector, \code{n} to the length of output expected, and \code{cov} , if present, passed in \code{...} . The function must return a numeric matrix with \code{length(params)} rows and \code{n} columns.
\item a numeric matrix to fix the gradient; this is useful when map is linear.
\item a character string to select (partially-matched) one of predefined forms. Currently, the defined forms include:
\itemize{
\item \code{"linear"} calculate the (constant) gradient matrix using finite differences. Note that this will be done only once at the initialization stage, so use only if you are certain \code{map} is, in fact, linear.
}
}}

\item{minpar, maxpar}{the minimum and maximum allowed curved parameter values. The parameters will be recycled to the appropriate length.}

\item{cov}{optional}
}
\description{
Arguments may have the same forms as in the API, but for convenience, alternative forms are accepted.

If the model in \code{formula} is curved, then the outputs of this operator term's \code{map} argument will be used as inputs to the curved terms of the \code{formula} model.

\code{Curve} is an obsolete alias and may be deprecated and removed in a future release.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "Curve", "subsection")}
}
\concept{operator}
