% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_calculations.R
\name{exact_loglik}
\alias{exact_loglik}
\alias{exact_loglik.default}
\alias{exact_gradient}
\alias{exact_gradient.default}
\alias{exact_hessian}
\title{Vectorized calculation of ERGM exact log-likelihood}
\usage{
exact_loglik(x, params, ..., as_prob = FALSE)

\method{exact_loglik}{default}(
  x,
  params,
  stats_weights,
  stats_statmat,
  target_offset = double(nrow(x)),
  stats_offset = lapply(stats_weights, function(i) double(length(i))),
  ...,
  as_prob = FALSE
)

exact_gradient(x, params, ...)

\method{exact_gradient}{default}(
  x,
  params,
  stats_weights,
  stats_statmat,
  target_offset = double(nrow(x)),
  stats_offset = lapply(stats_weights, function(i) double(length(i))),
  ...
)

exact_hessian(
  params,
  stats_weights,
  stats_statmat,
  stats_offset = lapply(stats_weights, function(i) double(length(i)))
)
}
\arguments{
\item{x}{Matrix. Observed statistics}

\item{params}{Numeric vector. Parameter values of the model.}

\item{...}{Arguments passed to the default methods.}

\item{as_prob}{Logical scalar. When \code{TRUE}, the function returns probabilities
instead of log-likelihoods.}

\item{stats_weights}{Either an integer vector or a list of integer vectors (see \link{exact_loglik}).}

\item{stats_statmat}{Either a matrix or a list of matrices (see \link{exact_loglik}).}

\item{target_offset}{Numeric vector of length \code{nrow(target_stats)}.}

\item{stats_offset}{List of numeric vectors, each of length equal to the
lengths of vectors in \code{stats_weights} (see details).}
}
\description{
This function can be compared to \link[ergm:ergm.allstats]{ergm::ergm.exact} with the statistics not
centered at \code{x}, the vector of observed statistics.
}
\section{Sufficient statistics}{


One of the most important components of \code{ergmito} is calculating the full
support of the model's sufficient statistics. Right now, the package uses
the function \link[ergm:ergm.allstats]{ergm::ergm.allstats} which returns a list of two objects:
\itemize{
\item \code{weights}: An integer vector of counts.
\item \code{statmat}: A numeric matrix with the rows as unique vectors of sufficient
statistics.
}

Since \code{ergmito} can vectorize operations, in order to specify weights and
statistics matrices for each network in the model, the user needs to pass
two lists \code{stats_weights} and \code{stats_statmat}. While both lists have to
have the same length (since its elements are matched), this needs not to
be the case with the networks, as the user can specify a single set of
weights and statistics that will be recycled (smartly).

In the case of offset terms, these can be passed directly via \code{target_offset}
and \code{stats_offset}. The first is a numeric vector of length equal to the
number of networks in the model. The later is a list of vectors that is
matched against \code{stats_weights}, so each of it's elements must be a
numeric vector of the same length that in the list of weights. By default
the offset terms are set to equal zero.
}

\examples{
data(fivenets)
ans <- ergmito(fivenets ~ edges + nodematch("female"))

# This computes the likelihood for all the networks independently
with(ans$formulae, {
  exact_loglik(
    x      = target_stats,
    params = coef(ans),
    stats_weights = stats_weights,
    stats_statmat = stats_statmat
  )
})

# This should be close to zero
with(ans$formulae, {
  exact_gradient(
    x      = target_stats,
    params = coef(ans),
    stats_weights = stats_weights,
    stats_statmat = stats_statmat
  )
})

# Finally, the hessian
with(ans$formulae, {
  exact_hessian(
    params = coef(ans),
    stats_weights = stats_weights,
    stats_statmat = stats_statmat
  )
})

}
