% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enp.R
\name{enp}
\alias{enp}
\title{Effective Number of Parties}
\usage{
enp(tidy_data, enp_seats = FALSE, summary = FALSE)
}
\arguments{
\item{tidy_data}{data.frame that contains the following variables with these names:
\itemize{
         \item{\code{election}: year of election.}
         \item{\code{unit}: the unit of analysis (province, department ...)}
         \item{\code{party}: name of the political parties that obtain votes.}
         \item{\code{votes}: votes obtained by each party.}
         \item{\code{seats}: .}
        }
If the data is not structured in this way you can order it with: \code{\link{convert_esaps}}.}

\item{enp_seats}{enp_seats = TRUE allows us to calculate jointly the effective
number of electoral parties and in the congress.}

\item{summary}{Summary of the data by unit, by default it is \code{FALSE}.}
}
\value{
if \code{summary = FALSE,} return data.frame.

    if \code{summary = TRUE}, return a list with two data.frame.
    \itemize{
            \item{\code{list[[1]]}} {Indicator}
            \item{\code{list[[2]]}} {Summary}
                  \itemize{
                      \item{\code{min} variable 'election'}
                      \item{\code{max} variable 'election'}
                      \item{number of elections}
                      \item{\code{mean} indicator}
                      }
     }
}
\description{
The Effective Number of Parties (ENP) is an index developed by
    Laakso and Taagepera (1979) that allows to count the relevant parties in a
    party system. The formula consists on dividing one over the sum of the squares
    of the proportions (votes or seats) that the parties obtain in an electoral instance.
}
\examples{
votes <- data.frame(election = rep(c(2000, 2005), each = 4),
                   unit  = rep(c("ARG", "URY"), each = 4),
                   party = c("party_A", "party_B","party_C","party_D"),
                   votes = c(20, 20, 50, 10, 30, 35, 25, 10),
                   seats = c(25, 25, 40, 10, 30, 30, 30, 10)
                   )

enp(votes)
enp(votes, enp_seats = TRUE)
enp(votes, summary = TRUE)

}
\author{
Nicolas Schmidt \email{nschmidt@cienciassociales.edu.uy}
}
