% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intolerable.R
\name{intolerable}
\alias{intolerable}
\title{intolerable}
\usage{
intolerable(esDf, intoleranceDf, RELEVANTINFO_ES = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{intoleranceDf}{a data.frame with 2 columns. The first column must contain the prompt index, which must \strong{never} be combined with the 'expected category' in the second column; the second column must contain the 'expected category' of the survey version (as specified by the user in the function \code{\link{expectedPromptIndex}}). See \strong{Details} for more information.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}
}
\value{
The user receives a list containing 2 datasets:
\enumerate{
\item cleanedDf, i.e. the ESM dataset from which the intolerable lines of data were removed.
\item intoleranceDf, i.e. the intolerable lines of data that were removed.
}
}
\description{
intolerable registers the intolerable ESM questionnaires as specified by the user.
}
\details{
The user must specify exactly which kind of ESM questionnaires are intolerable relative to the expectation, which was specified in the function \code{\link{expectedPromptIndex}}. For example, a questionnaire which was expected to be answered in the morning (specified by the expected category 1) must \strong{never} be combined with the last prompt of the day (e.g. 4). That is, it doesn't make sense to have the answers to the morning questionnaire, which was filled out in the evening.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute intolerable. Start --------------
# RELEVANTINFO_ES is delivered with the package
# expectedDf is a raw ESM dataset, delivered with the package.
# Prerequisites in order to execute intolerable. End ----------------
# -------------------------------------------------------
# Run function 24 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# Generate second argument of function 'intolerable'
(intoleranceDf <- data.frame(
# Column 'prompt': Prompts that must NEVER be comined with expected categories.
prompt = c(2, 3, 4, 1, 1),
# Column 'expect': Expected categories that must NEVER be combined with the prompts.
expect = c(1, 1, 1, 2, 3)))
# Read: Prompts 2, 3, and 4 must never be combined with expected category 1.
# Read: Prompt 1 must never be combined with expected category 2.
# Read: Prompt 1 must never be combined with expected category 3.
# expectedDf is the result of function 'expectedPromptIndex'.
intolLs <- intolerable(expectedDf, intoleranceDf, RELEVANTINFO_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 24 of 29).
}
