% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_serie.R
\name{extract_serie}
\alias{extract_serie}
\title{Extract time series of wrf file list of lat/lon}
\usage{
extract_serie(
  filelist,
  point,
  variable = "o3",
  field = "4d",
  level = 1,
  prefix = "serie",
  new = "check",
  return.nearest = FALSE,
  fast = FALSE,
  use_ij = FALSE,
  latitude = "XLAT",
  longitude = "XLONG",
  use_TFLAG = FALSE,
  use_datesec = FALSE,
  id = "id",
  remove_ch = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filelist}{list of files to be read}

\item{point}{data.frame with lat/lon}

\item{variable}{variable name}

\item{field}{'4d' (default), '3d', '2d' or '2dz' see notes}

\item{level}{model level to be extracted}

\item{prefix}{to output file, default is serie}

\item{new}{TRUE, FALSE of 'check' see notes}

\item{return.nearest}{return the data.frame of nearest points instead of extract the serie}

\item{fast}{faster calculation of grid distances but less precise}

\item{use_ij}{logical, use i and j from input instead of calculate}

\item{latitude}{name of latitude coordinate variable in the netcdf}

\item{longitude}{name of longitude coordinate variable in the netcdf}

\item{use_TFLAG}{use the variable TFLAG (CMAQ / smoke) instead of Times (WRF)}

\item{use_datesec}{use the variable date and datesec (WACCM / CAM-Chem) instead of Times (WRF)}

\item{id}{name of the column with station names, if point is a SpatVector (points) from terra package}

\item{remove_ch}{remove special characters on row.names}

\item{verbose}{display additional information}
}
\value{
No return value
}
\description{
Read and extract data from a list of wrf output files and a table of lat/lon points based on the distance of the points and the center of model grid points, points outside the domain (and points on domain boundary) are not extracted.
}
\note{
The field argument '4d' or '2dz' is used to read a 4d/3d variable droping the 3rd dimention (z).

new = TRUE create a new file, new = FALSE append the data in a old file, and new = 'check' check if the file exist and append if the file exist and create if the file doesnt exist

FOR CAMx time-series, use the options: use_TFLAG=T, latitude='latitude', longitude='longitude', new=T

FOR WACCM time-series, use the options: use_datesec=T, latitude='lat', longitude='lon', new=T

The site-list of two global data-sets (METAR and AERONET) are provided on examples and site-list for stations on Brazil (INMET and Air Quality stations).
}
\examples{
cat('Example 1: METAR site list\n')
sites <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_METAR.Rds"))

cat('Example 2: Integrated Surface Dataset (ISD) site list\n')
sites <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_ISD.Rds"))

cat('Example 4: AERONET site list\n')
sites <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_AERONET.Rds"))

cat('Example 5: list of INMET stations on Brazil\n')
sites <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_INMET.Rds"))

cat('Example 6: list of Air Quality stations on Brazil\n')
sites <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_AQ_BR.Rds"))

files    <- dir(path = system.file("extdata",package="eva3dm"),
                pattern = 'wrf.day',
                full.names = TRUE)
dir.create(file.path(tempdir(),"SERIE"))
folder <- file.path(tempdir(),"SERIE")

# extract data for 3 locations
extract_serie(filelist = files, point = sites[1:3,],prefix = paste0(folder,'/serie'))

}
