% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAPD.R
\name{PAPD}
\alias{PAPD}
\title{Estimation of the Population Average Prescription Difference in Randomized Experiments}
\usage{
PAPD(T, Thatfp, Thatgp, Y, budget, centered = TRUE)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{Thatfp}{A vector of the unit-level binary treatment that would have been assigned by the
first individualized treatment rule. Please ensure that the percentage of treatment units of That is lower than the budget constraint.}

\item{Thatgp}{A vector of the unit-level binary treatment that would have been assigned by the
second individualized treatment rule. Please ensure that the percentage of treatment units of That is lower than the budget constraint.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{budget}{The maximum percentage of population that can be treated under the
budget constraint. Should be a decimal between 0 and 1.}

\item{centered}{If \code{TRUE}, the outcome variables would be centered before processing. This minimizes
the variance of the estimator. Default is \code{TRUE}.}
}
\value{
A list that contains the following items: \item{papd}{The estimated
Population Average Prescription Difference} \item{sd}{The estimated standard deviation
of PAPD.}
}
\description{
This function estimates the Population Average Prescription Difference with a budget
constraint. The details of the methods for this design are given in Imai and Li (2019).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
That = c(0,1,1,0,0,1,1,0)
That2 = c(1,0,0,1,1,0,0,1)
Y = c(4,5,0,2,4,1,-4,3)
papdlist <- PAPD(T,That,That2,Y,budget = 0.5)
papdlist$papd
papdlist$sd
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{evaluation}
