% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hargreaves_samani.R
\name{hargreaves_samani}
\alias{hargreaves_samani}
\alias{hargreaves_samani,Raster,Raster,Raster-method}
\alias{hargreaves_samani,character,character,character-method}
\alias{hargreaves_samani,missing,missing,missing-method}
\title{Calculate Potential Evapotranspiration (PET) using Hargreaves-Samani method}
\usage{
hargreaves_samani(tavg, tmax, tmin, x = NULL)

\S4method{hargreaves_samani}{Raster,Raster,Raster}(tavg, tmax, tmin, x = NULL)

\S4method{hargreaves_samani}{character,character,character}(tavg, tmax, tmin, x = NULL)

\S4method{hargreaves_samani}{missing,missing,missing}(x)
}
\arguments{
\item{tavg}{Raster* object or file path; average temperature (°C)}

\item{tmax}{Raster* object or file path; maximum temperature (°C)}

\item{tmin}{Raster* object or file path; minimum temperature (°C)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "tavg", "tmin", "tmax".}
}
\value{
RasterBrick or data.table of PET values (mm/day)
}
\description{
The function \code{hargreaves_samani} computes PET using the Hargreaves and Samani method.
}
\details{
For Raster inputs, provide raster objects or file paths for average (`tavg`),
maximum (`tmax`), and minimum (`tmin`) temperature. For `data.table` input,
provide a table with columns: "lon", "lat", "date", "tavg", "tmin", and "tmax".
}
\keyword{internal}
