% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oob_evaluation.R
\name{oob_evaluation}
\alias{oob_evaluation}
\title{Out of bag predictive performance of EVZINB and EVINB models}
\usage{
oob_evaluation(
  object,
  predict_type = c("harmonic", "explog"),
  metric = c("rmsle", "rmse", "mse", "mae")
)
}
\arguments{
\item{object}{A fitted evzinb or evinb with bootstraps on which to conduct out-of-bag evaluation}

\item{predict_type}{What type of prediction should be made? Harmonic mean, or exp(log(prediction))?}

\item{metric}{What metric should be used for the out of bag evaluation? Default options include rmsle, rmse, mse, and mae. Can also take a user supplied function of the form function(y_pred,y_true) which returns a single value}
}
\value{
A vector of oob evaluation metrics of the length of the number of bootstraps in the evzinb/evinb object.
}
\description{
Out of bag predictive performance of EVZINB and EVINB models
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10)
oob_evaluation(model)

}
