% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateBirthDeathRich.R
\name{simulateBirthDeathRich}
\alias{simulateBirthDeathRich}
\title{Simulating richness through birth-death processes}
\usage{
simulateBirthDeathRich(t, S = NULL, E = NULL, K = NULL, R = NULL)
}
\arguments{
\item{t}{Point in time which richness will be simulated.}

\item{S}{A numeric representing the per-capita speciation rate (in number
of events per lineage per million years). Must be larger than \code{E}.}

\item{E}{A numeric representing the per-capita extinction rate (in number
of events per lineage per million years). Must be smaller than \code{S}.}

\item{K}{A numeric representing the extinction fraction (i.e.,
\code{K} = \code{E} / \code{S}). Must be either zero or a positive
which is number smaller than one.}

\item{R}{A numeric representing the per-capita Net Diversification
rate (i.e., \code{R} = \code{S} - \code{E}). Must be a positive number.}
}
\value{
The number of simulated species (i.e., the richness).
}
\description{
\code{simulateBirthDeathRich} calculates the number of species at a certain
point in time, following a birth-death process.
}
\details{
The function only accepts as inputs \code{S} and \code{E}, or
\code{K} and \code{R}.
}
\examples{
# running a single simulation:
SS <- 0.40
EE <- 0.09
tt <- 10 #in Mya
simulateBirthDeathRich(t = tt, S = SS, E = EE)

#running many simulations and graphing results:
nSim <- 1000
res <- vector()
for(i in 1:nSim){
  res <- c(res, 
  simulateBirthDeathRich(t = tt, S = SS, E = EE))
}
plot(table(res)/length(res),
     xlab="Richness", ylab="Probability")
}
\references{
Raup, D. M. (1985). Mathematical models of cladogenesis.
Paleobiology, 11(1), 42-52.
}
\author{
Matheus Januario, Daniel Rabosky, Jennifer Auler
}
