% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{choose_k_GMM}
\alias{choose_k_GMM}
\title{Visualize BIC indicator to choose the number of clusters}
\usage{
choose_k_GMM(
  sessions,
  k,
  mclust_tol = 1e-08,
  mclust_itmax = 10000,
  log = getOption("evprof.log", FALSE),
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof standard format}

\item{k}{sequence with the number of clusters, for example 1:10, for 1 to 10 clusters.}

\item{mclust_tol}{tolerance parameter for clustering}

\item{mclust_itmax}{maximum number of iterations}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
BIC plot
}
\description{
The Baysian Information Criterion (BIC) is the value of the maximized
loglikelihood with a penalty on the number of parameters in the model,
and allows comparison of models with differing parameterizations and/or
differing numbers of clusters. In general the larger the value of the BIC,
the stronger the evidence for the model and number of clusters
(see, e.g. Fraley and Raftery 2002a).
}
\examples{
\donttest{
choose_k_GMM(california_ev_sessions, k = 1:4, start = 3)
}


}
