% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNames.R
\name{getNames}
\alias{getNames}
\title{Safely extract names from an object}
\usage{
getNames(x, strict = FALSE)
}
\arguments{
\item{x}{An R object (vector, list, etc.). Must not be \code{NULL}.}

\item{strict}{Logical; if TRUE, errors if \code{x} is \code{NULL}, any names are missing,
or any names are empty strings.}
}
\value{
A character vector of names, same length as \code{x}.
\itemize{
\item If \code{x} is an empty list or zero-length object, returns \code{character(0)}.
\item If \code{names(x)} is \code{NULL} and \code{strict = FALSE}, returns a vector of empty strings of the same length as \code{x}.
}
}
\description{
Returns the names of an object as a character vector. Optionally enforces that
names are non-NULL and non-empty when \code{strict = TRUE}. The function \strong{does not
modify the original object}.
}
\examples{
x <- c(a = 1, b = 2)
getNames(x)

y <- 1:3
getNames(y)

z <- c(1, 2); names(z) <- c("a", "")
# getNames(z, strict = TRUE) # would throw an error: "`x` has empty name(s)"

# Empty list returns character(0)
getNames(list(), strict = TRUE)

# NULL input triggers an error
# getNames(NULL, strict = TRUE)

}
