% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_personsItems.R
\name{test_personsItems}
\alias{test_personsItems}
\title{checks the relationship between the person parameter distribution and
 the item (or: threshold) locations for defined criteria}
\usage{
test_personsItems(
  items = NULL,
  dset = NULL,
  na.rm = TRUE,
  model = NULL,
  p.par = NULL,
  modelType = NULL,
  gap_prop = 0,
  extremes = TRUE,
  estimation_param = NULL
)
}
\arguments{
\item{items}{a numeric vector containing the index numbers of the items
in dset that are used to fit the model}

\item{dset}{a data.frame containing the data}

\item{na.rm}{a boolean value. If TRUE, all cases with any NA are removed
(na.omit). If FALSE, only cases with full NA responses are removed}

\item{model}{on object of a fit Rasch model, estimated with the packages
'eRm' (classes 'RM', 'PCM' or 'RSM'), 'psychotools' (classes raschmodel,
'pcmodel' or 'rsmodel') or 'pairwise' (class 'pers'), matching the value of
 modelType. If 'model' is provided, this model is used. If NULL, a model is
 fit using 'dset' and 'items'.}

\item{p.par}{a person parameter object matching the class of 'model'. If
NULL, the person parameters will be estimated.}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: "RM", "PCM", "RSM".}

\item{gap_prop}{a numeric value between 0 and 1 that sets the criterion
for the minimum proportion of neighboring person parameters with an
 item/threshold location in between. If set to 0, this criterion will
  not be checked.}

\item{extremes}{a boolean value indicating if a check for the
item/threshold locations left of the 2nd lowest and right of the 2nd
 highest person parameter.}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}
}
\value{
if the criteria are met, a list containing 3 elements is returned:
 the item combination that was tested, a list of the class the model was
 estimated with (depending on modelType and estimation_param$est) with the
 fit model and a list with a person parameter object (depending on
 estimation_param$est).  If the criteria are not met, NULL is returned.
}
\description{
checks the relationship between the person parameter distribution and
 the item (or: threshold) locations for defined criteria
}
\keyword{internal}
