% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{raptMake}
\alias{raptMake}
\title{Define a Random Affine Projection Transformation (RAPT) object}
\usage{
raptMake(p, q, Wdist = rnorm, WdistOpt = NULL, bDist = runif,
  bDistOpt = list(min = 0, max = 0))
}
\arguments{
\item{p}{Number of input features (columns of \code{X}).}

\item{q}{Number of output features,}

\item{Wdist}{W distribution function.  Coefficients for
the random projection matrix W are drawn from
this distribution.  The default is rnorm.}

\item{WdistOpt}{List of optional parameters for Wdist.
If this is NULL (default),
then only defaults of the distribution
are used.}

\item{bDist}{b distribution function.  Coefficients for
the offset vector b are drawn from this
distribution.   The default is runif.}

\item{bDistOpt}{List of optional parameters for bDist.
If this is NULL
then only defaults of the distribution
are used.  The default is
\code{bDistOpt=list(min=0,max=0)},
which results in b = 0, with no offset.}
}
\value{
An expand object, which defines the following fields:
  W       Input weighting matrix
  b       Input offset matrix
}
\description{
Create a Random Affine Projection Transformation (RAPT) object.
Such objects use random affine projection transformation to the
resulting matrix.  This allows RAPT objects serve as a basis
for a large number of kinds of expansions.
}
\details{
This initializes a eRAPTobj, which holds all the
         parameters needed to perform a random projection
         transformation expansion (RAPT).

         An RAPT of X is defined as

         \deqn{X W + b}

         where

         X is the input matrix

         W is a matrix of coefficients drawn from Wdist with
           options WdistOpt

         b is a column matrix of coefficients drawn from bDist
           with options bDistOpt

         If there is a need for multiple W or b distributions,
         then make multiple raptObj.  This makes
         each raptObj fairly simple, while allowing arbitrary
         complexity through multiple expansion and composition.

         A simple way to get a linear feature, in addition
         to the RAPT features, is to simply cbind the
         original matrix X in with the raptObj matrix.
}
\examples{
raptObj <- raptMake(21,210,bDistOpt=list(min=-pi,max=+pi))
}

