% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAPD.R
\name{PAPD}
\alias{PAPD}
\title{Estimation of the Population Average Prescription Difference in Completely Randomized Experiments}
\usage{
PAPD(T, Thatfp, Thatgp, Y, plim)
}
\arguments{
\item{T}{The unit-level binary treatment receipt variable.}

\item{Thatfp}{The unit-level binary treatment that would have been assigned by the 
first individualized treatment rule.}

\item{Thatgp}{The unit-level binary treatment that would have been assigned by the 
second individualized treatment rule.}

\item{Y}{The outcome variable of interest.}

\item{plim}{The maximum percentage of population that can be treated under the
budget constraint. Should be a decimal between 0 and 1.}
}
\value{
A list that contains the following items: \item{papd}{The estimated
Population Average Prescription Difference} \item{sd}{The estimated standard deviation
of PAPD.}
}
\description{
This function estimates the Population Average Prescription Difference with a budget
constraint. The details of the methods for this design are given in Imai and Li (2019).
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
