% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{add_index}
\alias{add_index}
\title{Add an index column at the first place of a tibble}
\usage{
add_index(tbl, name_index = "index", start = 1, .force = FALSE)
}
\arguments{
\item{tbl}{tibble or data frame}

\item{name_index}{A character string of the name of the column.}

\item{start}{integer indicating first index number. 1 by default.}

\item{.force}{TRUE or FALSE, that parameter indicates whether or not the
column is created if already exists. FALSE by default.}
}
\value{
A tibble or a data frame containing one extra first column 'index' or
any given name.
}
\description{
Add an index, possibly by group, at the first place of a data frame or a
tibble The name by default is 'index' but can be named. If 'index' already
exists, or the given name, the column can be forced to be created, and
replace the other one.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# add an index for the tibble
add_index(iris, "my_index")

##### Example 2 -------------------------------------------------------------
# add an index for the grouped tibble
library(tidyr)
library(dplyr)

my_tbl <- tibble(iris) \%>\% group_by(Species) \%>\% slice(1:3)
add_index(my_tbl, "my_index")

}

}
