% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_factorial.R
\name{tidy.iv_factorial}
\alias{tidy.iv_factorial}
\title{Tidy an iv_factorial object}
\usage{
\method{tidy}{iv_factorial}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An \code{iv_factorial} object produced by a call to \code{\link[=iv_factorial]{iv_factorial()}}}

\item{conf.int}{Logical indicating whether or not to include a
confidence interval in the tidied output. Defaults to \code{FALSE}}

\item{conf.level}{The confidence level to use for the confidence
interval if \code{conf.int = TRUE}. Must be strictly greater than 0
and less than 1. Defaults to 0.95, which corresponds to a 95
percent confidence interval.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
\item{term}{The name of the effect term.}
\item{estimand}{Which complier effect being estimated.}
\item{estimate}{The estimated value of the effect.}
\item{std.error}{The estimated standard error of the effect.}
\item{conf.low}{Lower bound of the confidence interval for the
estimate.}
\item{conf.high}{Upper bound of the confidence interval for the
estimate.}
}
\description{
Tidy summarizes information about the components of a model.
}
\author{
Matt Blackwell
}
