% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor256.R
\name{factor256}
\alias{factor256}
\alias{recompose256}
\alias{relevel256}
\alias{levels.factor256}
\alias{is.factor256}
\alias{isntSorted256}
\alias{as_factor}
\alias{factor256_in}
\alias{factor256_notin}
\alias{factor256_ein}
\alias{factor256_enotin}
\alias{tabulate256}
\alias{rank256}
\alias{order256}
\alias{unique256}
\alias{tabulate256_levels}
\title{Factors of fewer than 256 elements}
\usage{
factor256(x, levels = NULL)

recompose256(f)

relevel256(x, levels)

\method{levels}{factor256}(x)

is.factor256(x)

isntSorted256(x, strictly = FALSE)

as_factor(x)

factor256_in(x, tbl)

factor256_notin(x, tbl)

factor256_ein(x, tbl)

factor256_enotin(x, tbl)

tabulate256(f)

rank256(x)

order256(x)

unique256(x)

tabulate256_levels(x, nmax = NULL, dotInterval = 65535L)
}
\arguments{
\item{x}{An atomic vector with fewer than 256 unique elements.}

\item{levels}{An optional character vector of or representing the unique values of \code{x}.}

\item{f}{A raw vector of class \code{factor256}.}

\item{strictly}{If \code{TRUE} then if \code{x[i] == x[j]} and \code{i != j}
then \code{x} is not sorted.}

\item{tbl}{The table of values to lookup in \code{f}. May be a \code{factor256}
class but will be implicitly converted based on the levels of \code{f}.}

\item{nmax, dotInterval}{(\code{tabulate256_levels} only). Every \code{dotInterval}
iterations through \code{x} check number of unique elements detected so far. If any count exceeds
\code{nmax} the rest of the vector is ignored.}
}
\value{
\code{factor256} is a class based on raw vectors.
Values in \code{x} absent from \code{levels} are mapped to \code{00}.

In the following list, \code{o} is the result.

\describe{
\item{\code{factor256}}{A raw vector of class \code{factor256}.}
\item{\code{recompose256}}{is the inverse operation.}
\item{\code{factor256_e?(not)?in}}{A logical vector the same length of \code{f}, \code{o[i] = TRUE} if
\code{f[i]} is among the values of \code{tbl} when converted to \code{factor256}.
\code{_notin} is the negation. The \code{factor256_e} variants will error if
none of the values of \code{tbl} are present in \code{f}.}
\item{\code{tabulate256}}{Takes a raw vector and counts the number of times
each element occurs within it. It is always length-256; if an element is absent
it will have value zero in the output.}
\item{\code{tabulate256_levels}}{Similar to \code{tabulate256} but with optional arguments \code{nmax},
\code{dotInterval}.}
\item{\code{as_factor}}{Converts from \code{factor256} to \code{factor}.}
\item{\code{order256}}{Same as \code{order} but supports raw vectors. \code{order256(x)}}
\item{\code{rank256}}{Same as \code{rank} with \code{ties.method = "first"} but supports raw vectors.}
\item{\code{unique256}}{Unique elements of.}

}
}
\description{
Whereas base R's factors are based on 32-bit integer vectors,
\code{factor256} uses 8-bit raw vectors to minimize its memory footprint.
}
\examples{
f10 <- factor256(1:10)

fletters <- factor256(rep(letters, 1:26))
head(factor256_in(fletters, "g"))
head(tabulate256(fletters))
head(recompose256(fletters))

gletters <- factor256(rep(letters, 1:26), levels = letters[1:25])
tail(tabulate256(gletters))
tabulate256_levels(gletters, nmax = 5L, dotInterval = 1L)


}
