% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.normality.datatable.R
\name{residuals.normality.datatable}
\alias{residuals.normality.datatable}
\title{Global residual normality (Shapiro–Wilk) from ANOVA models}
\usage{
\method{residuals}{normality.datatable}(formula, data, force_factors = TRUE)
}
\arguments{
\item{formula}{A model formula \code{y ~ A + B (+ C ...)}.}

\item{data}{A data frame with the variables.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}
}
\value{
A data.frame with one row per \code{Effect} (A, B, A:B, ...), with
\code{count}, \code{W}, \code{p.shapiro} (4 decimals), \code{OK}.
}
\description{
For each subset of RHS factors, fits a full-factorial ANOVA and runs a single
Shapiro–Wilk test on the model residuals (global test per model). Use
\code{residuals.cellwise.normality.datatable} for the stricter per-cell assumption.
}
\examples{
\dontrun{
residuals.normality.datatable(liking ~ gender + condition + age_cat, data = mimicry)
}
}
\seealso{
\code{\link{residuals.cellwise.normality.datatable}}
}
