% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit2x2.R
\name{crit2x2}
\alias{crit2x2}
\title{Critical values for the Equal Allocation 3, Proportional Allocation 2,
and Equal Allocation 2 procedures}
\usage{
crit2x2(
  corAa,
  corAab,
  coraab,
  dig = 2,
  alpha = 0.05,
  niter = 5,
  abseps = 1e-05,
  tol = 1e-04
)
}
\arguments{
\item{corAa}{correlation between the overall A and simple A log hazard ratio estimates}

\item{corAab}{correlation between the overall A and simple AB log hazard ratio estimates}

\item{coraab}{correlation between the simple A and simple AB log hazard ratio estimates}

\item{dig}{number of decimal places to which we \code{\link{roundDown}} the critical value}

\item{alpha}{two-sided familywise error level to control}

\item{niter}{number of times we compute the critical values to average out
the randomness from the \code{pmvnorm} function call}

\item{abseps}{\code{abseps} setting in the \code{pmvnorm} function call}

\item{tol}{\code{tol} setting in the uniroot function call}
}
\value{
\item{critEA3 }{Equal Allocation 3 procedure's critical value for all three test statistics}
\item{sigEA3 }{two-sided nominal significance level corresponding to \code{critEA3}}
\item{critPA2A }{Proportional Allocation 2 procedure's critical value for the overall A statistic}
\item{sigPA2A }{two-sided nominal significance level corresponding to \code{critPA2A}}
\item{critPA2ab }{Proportional Allocation 2 procedure's critical value for the simple AB statistic}
\item{sigPA2ab }{two-sided nominal significance level corresponding to \code{critPA2ab}}
\item{critEA2 }{Equal Allocation 2 procedure's critical value for the simple A and AB statistics}
\item{sigEA2 }{two-sided nominal significance level corresponding to \code{critEA2}}
}
\description{
Computes  the critical values
for null hypotheses rejection and corresponding nominal two-sided significance
levels for the Equal Allocation 3, Proportional Allocation 2,
and Equal Allocation 2 procedures
}
\details{
This function computes the Dunnett-corrected critical values
based on the asymptotic correlations of the overall A, simple A, and simple AB
logrank statistics as described in Leifer, Troendle, et al. (2020) and are derived in
Lin, Gong, et al. (2016) and Slud (1994).  \code{pmvnorm} uses a random seed in its algorithm.
To smooth out the randomness,  \code{pmvnorm} is called \code{niter} times.
The \code{roundDown} function is used in conjunction with the \code{dig} argument
to insure that any rounding of the (negative) critical values will be done conservatively to control
the familywise type I error at the desired level.
}
\examples{
# Example 1:  Compute the nominal significance levels for rejection using
# the asymptotic correlations derived in Slud (1994)
corAa  <- 1/sqrt(2)
corAab <- 1/sqrt(2)
coraab <- 1/2

crit2x2(corAa, corAab, coraab, dig = 2, alpha = 0.05, niter = 5)
# critEA3
# [1] -2.32

# sigEA3
# [1] 0.02034088

# critPA2A
# [1] -2.13

# sigPA2A
# [1] 0.03317161

# critPA2ab
# [1] -2.24

# sigPA2ab
# [1] 0.02509092

# critEA2
# [1] -2.22

# sigEA2
# [1] 0.02641877

# Example 2:  Compute the nominal critical values and significance levels for rejection
# using the estimated correlations for simdat.
corAa  <- 0.6123399
corAab <- 0.5675396
coraab <- 0.4642737

crit2x2(corAa, corAab, coraab, dig = 2, alpha = 0.05, niter = 5)
# $critEA3
# [1] -2.34

# $critPA2A
# [1] -2.13

# $sigPA2A
# [1] 0.03317161

# $critPA2ab
# [1] -2.3

# $sigPA2ab
# [1] 0.02144822
#
# $sigEA3
# [1] 0.01928374

# $critEA2
# [1] -2.22

# $sigEA2
# [1] 0.02641877
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. 2020. Submitted.

Lin, D-Y., Gong, J., Gallo, P., et al. Simultaneous inference on treatment effects
in survival studies with factorial designs. Biometrics. 2016; 72: 1078-1085.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{roundDown}. \code{eventProb}, \code{lgrkPower}, \code{strLgrkPower}, \code{pmvnorm}
}
