% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_metric.R
\name{group_metric}
\alias{group_metric}
\title{Group metric}
\usage{
group_metric(
  x,
  fairness_metric = NULL,
  performance_metric = NULL,
  parity_loss = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{fairness_metric}{character, fairness metric name, if \code{NULL} the default metric will be used which is TPR.}

\item{performance_metric}{character, performance metric name}

\item{parity_loss}{logical, if \code{TRUE} parity loss will supersede basic metric}

\item{verbose}{logical, whether to print information about metrics on console or not. Default \code{TRUE}}
}
\value{
\code{group_metric} object.
It is a list with following items:
\item{group_metric_data}{ - \code{data.frame} containing fairness metric scores for each model}
\item{performance_data}{ - \code{data.frame} containing performance metric scores for each model}
\item{fairness_metric}{ - name of fairness metric}
\item{performance_metric}{ - name of performance metric}
}
\description{
Group metric enables to extract data from metrics generated for each subgroup (values in protected variable)
The closer metric values are to each other, the less bias particular model has. If \code{parity_loss} parameter is set to \code{TRUE}, distance between
privileged and unprivileged subgroups will be measured. When plotted shows both fairness metric and chosen performance metric.
}
\details{
Available metrics:

Fairness metrics (Full names explained in \code{fairness_check} documentation):

\itemize{
  \item TPR: True Positive Rate
  \item TNR: True Negative Rate
  \item PPV: Positive Predictive Value
  \item NPV: Negative Predictive Value
  \item FNR: False Negative Rate
  \item FPR: False Positive Rate
  \item FDR: False Discovery Rate
  \item FOR: False Omission Rate
  \item TS: Threat Score
  \item ACC: Accuracy
  \item STP: Statistical Parity
  \item F1: F1 Score
}

Performance metrics:

\itemize{
  \item recall: Recall
  \item precision: Precision
  \item accuracy: Accuracy
  \item f1: F1 Score
  \item auc: Area Under the Curve
}
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)


explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

gm <- group_metric(fobject, "TPR", "f1", parity_loss = TRUE)
plot(gm)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200
)

explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

gm <- group_metric(fobject, "TPR", "f1", parity_loss = TRUE)

plot(gm)
}

}
